<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use app\Models\Entidade;
use app\Models\Role;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOneOrMany;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'entidade_id',
        'role_id',
        'estado_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    // Usuário pertence a uma entidade
    public function entidade():BelongsTo
    {
        return $this->belongsTo(Entidade::class);
    }

    // Usuário tem um role
    public function role():BelongsTo
    {
        return $this->belongsTo(Role::class);
    }

    // Usuário tem pode ser responsável de muitas provincias
    public function provinces():HasMany
    {
        return $this->HasMany(Province::class);
    }

    // 
    public function municipios():HasOneOrMany
    {
        return $this->HasOneOrMany(Municipio::class);
    }

}
